#include <Wire.h>
#include <Adafruit_ADS1015.h>
#include <Adafruit_NeoPixel.h>

#define PIN  25      //RGB LED Din
#define NUMPIXELS 1

#define RXD2  23    //RS485
#define TXD2  13    //RS485
#define FC   32     //FLOW-CONTROL RS-485
#define BUTTON   35

#define D1  18       //Digital Input1
#define D2  26       //Digital Input2
#define D3  27       //Digital Input1

Adafruit_NeoPixel pixels(NUMPIXELS, PIN, NEO_GRB + NEO_KHZ800);

Adafruit_ADS1115 ads(0x48);       //ADS address
float Voltage1 = 0.0;
float Voltage2 = 0.0;
float Voltage3 = 0.0;
void setup(void)
{
  ads.begin();
  pixels.begin();
  Serial.begin(9600);
  Serial2.begin(9600, SERIAL_8N1, RXD2, TXD2); //Serial 2 definition for RS-485 connection
  pinMode(BUTTON , INPUT);
  pinMode(D1, INPUT);
  pinMode(D2, INPUT);
  pinMode(D3, INPUT);
  pinMode(FC , OUTPUT);
  digitalWrite(FC , HIGH);

}

void loop(void)
{
  float adc0;
  float adc1;
  float adc2;

  adc0 = ads.readADC_SingleEnded(0);
  adc1 = ads.readADC_SingleEnded(1);
  adc2 = ads.readADC_SingleEnded(2);

  Voltage1 = (adc0 * 0.1875) / 200;
  Voltage2 = (adc1 * 0.1875) / 200;
  Voltage3 = (adc2 * 0.1875) / 200;


  Serial.print("\nAIN0: ");
  Serial.print(adc0);
  Serial.print("\tCurrent1: ");                 //Voltage check
  Serial.println(Voltage1 , 3);

  Serial.print("\nAIN1: ");
  Serial.print(adc1);
  Serial.print("\tCurrent2: ");                 //Voltage check
  Serial.println(Voltage2 , 3);

  Serial.print("\nAIN2: ");
  Serial.print(adc2);
  Serial.print("\tCurrent3: ");                 //Voltage check
  Serial.println(Voltage3, 3);
  Serial.print("\n");

  Serial.print("D1: ");                        //Digital Inputs Check
  Serial.print(digitalRead(D1));
  Serial.print("\tD2: ");
  Serial.print(digitalRead(D2));
  Serial.print("\tD3: ");
  Serial.print(digitalRead(D3));
  Serial.print("\n");
  
  Serial.print("BUTTON: ");                        //Digital Inputs Check
  Serial.print(analogRead(35));
  Serial.print("\n");
  
  pixels.setBrightness(30);                   //LED Check
  pixels.setPixelColor(0, pixels.Color(255, 0, 0));
  pixels.show();
  delay(500);

  pixels.setBrightness(30);
  pixels.setPixelColor(0, pixels.Color(0, 255, 0));
  pixels.show();
  delay(500);


  pixels.setBrightness(30);
  pixels.setPixelColor(0, pixels.Color(0, 0, 255));
  pixels.show();
  delay(500);

  pixels.clear();
  pixels.show();

  Serial2.print("RS-485 TEST SUCCESS");
  Serial2.flush();
  delay(500);
  digitalWrite(FC , LOW);
  delay(500);
  digitalWrite(FC , HIGH);
  delay(500);
}
